
struct OutputBuffer
{
	float3 Pos ;
	float3 Norm ;
	float3 TexCd ;
	uint3 Indices;

};

StructuredBuffer<float3> PositionBuffer;
StructuredBuffer<float3> NormalsBuffer;
StructuredBuffer<float3> UvBuffer;
ByteAddressBuffer IndicesBuffer;

RWStructuredBuffer<OutputBuffer> Output : BACKBUFFER;

[numthreads(64, 1, 1)]
void GeomtryStructured_CS( uint3 i : SV_DispatchThreadID)
{ 
	
uint index=i.x;	
	
	uint i1 = IndicesBuffer.Load(index * 12);
	uint i2 = IndicesBuffer.Load(index * 12+4);
	uint i3 = IndicesBuffer.Load(index * 12+8);
	
	uint3 indices = uint3(i1,i2,i3);

	float3 Pos = PositionBuffer[index];
	float3 Norm = NormalsBuffer[index];
	float3 TexCd = UvBuffer[index];

Output[i.x].Pos=Pos;
Output[i.x].Norm=Norm;
Output[i.x].TexCd=TexCd;
Output[i.x].Indices=indices;
	
}

technique11 TGeomtryStructured
{
	pass P0
	{
		SetComputeShader( CompileShader( cs_5_0, GeomtryStructured_CS() ) );
	}
}





